#ifndef _DATETIME_CPP
#define _DATETIME_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <ATLTime.H>


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Convert Hour, Minute & Second To A DWORD Value

DWORD TimeToLong(int iHour, int iMin, int iSec)
{
    return (iHour * 60l + iMin) * 60l + iSec;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Convert A DWORD Value To Hour, Minute & Second

void LongToTime(DWORD dwTime, int *piHour, int *piMin, int *piSec)
{
    *piSec  = (int) dwTime % 60l;
    dwTime  /= 60l;
    *piMin  = (int) dwTime % 60l;
    *piHour = (int) dwTime / 60l;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Convert Year, Month & Day To A DWORD Value

DWORD DateToLong(int iYear, int iMonth, int iDay)
{
    int a = 0;
    int b = 0;

    int year  = iYear;
    int month = iMonth;
    int day   = iDay;

    float year_corr = 0;

    if( year < 0) year++;

    year_corr = (float) ( year > 0 ? 0.0 : 0.75 );

    if( month <= 2 )
    {
        year--;
        month += 12;
    }

    b = 0;

    if( year * 10000.0 + month * 100.0 + day >= 15821015.0 )
    {
        a = year / 100;
        b = 2 - a + a / 4;
    }

    return (DWORD) ( 365.25 * year - year_corr ) + (DWORD) ( 30.6001 * ( month + 1 ) ) + day + 1720995L + b;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Convert A DWORD Value To Year, Month & Day

void LongToDate(DWORD dwDate, int *piYear, int *piMonth, int *piDay)
{
    DWORD a = 0;
    DWORD b = 0;
    DWORD c = 0;
    DWORD d = 0;
    DWORD e = 0;
    DWORD z = 0;
    DWORD alpha = 0;

    z = dwDate;

    if ( z < 2299161L ) a = z;
    else{
        alpha = (DWORD) ( ( z - 1867216.25 ) / 36524.25 );
        a = z + 1 + alpha - alpha / 4;
    }

    b = a + 1524;
    c = (DWORD) ( ( b - 122.1 ) / 365.25 );
    d = (DWORD) ( 365.25 * c );
    e = (DWORD) ( ( b - d ) / 30.6001 );

    *piDay   = (int) (b - d - (DWORD) (30.6001 * e) );
    *piMonth = (int) (e < 13.5) ? e - 1 : e - 13;
    *piYear  = (int) (*piMonth > 2.5) ? (c - 4716) : c - 4715;

    if ( *piYear <= 0 ) *piYear -= 1;

    return;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void TimetToFileTime(time_t t, LPFILETIME pft)
{
    LONGLONG ll = Int32x32To64(t, 10000000) + 116444736000000000;
    pft->dwLowDateTime = (DWORD) ll;
    pft->dwHighDateTime = (DWORD)(ll>>32);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool TimetToSystemTime(time_t MyTime_T, LPSYSTEMTIME pST)
{
    FILETIME pft;

    TimetToFileTime(MyTime_T, &pft);

    if(!FileTimeToSystemTime(&pft, pST))
        return false;

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool TimetToLocalTime(time_t MyTime_T, LPSYSTEMTIME pLT)
{
    SYSTEMTIME pST;
    TIME_ZONE_INFORMATION TZI;

    if(!TimetToSystemTime(MyTime_T, &pST))
        return false;
    if(GetTimeZoneInformation(&TZI) == 0xFFFFFFFF)
        return false;
    if(!SystemTimeToTzSpecificLocalTime(&TZI, &pST, pLT))
        return false;

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
